import sopel.module
import sqlite3
import os
from mastodon import Mastodon


@sopel.module.commands('shout')
def shout(bot, trigger):
    db = os.environ.get('SHOUT_DB')
    if not db:
        db = bot.config.shout.db
    
    conn = sqlite3.connect(db)
    c = conn.cursor()
    
    mastodon = Mastodon(
        access_token = bot.config.mastodon.access_token,
        api_base_url = bot.config.mastodon.api_base_url
    )
    
    c.execute('''INSERT INTO shouts(created_at,name,message) VALUES(?,?,?)''', (trigger.time, trigger.nick, trigger.group(2) ))
    mastodon.toot('Shoutout from ' + trigger.nick +' : ' + trigger.group(2))
    
    conn.commit()
    conn.close()
    
    bot.say("shouting!")
