#!/usr/bin/env bash
. settings.env
LINKNAME="$1"
HOSTNAME=`hostname`

#usage: openob config_host node_name link_name tx [-h]
#                                                 [-a {auto,alsa,jack,test}]
#                                                 [-d ALSA_DEVICE]
#                                                 [-jn JACK_NAME] [-aj]
#                                                 [-r SAMPLERATE]
#                                                 [-e {pcm,opus}] [-p PORT]
#                                                 [-m] [--no-multicast]
#                                                 [-j JITTER_BUFFER] millisecs default 40
#                                                 [-b {16,24,32,48,64,96,128,192,256,384}]
#                                                 [-l LOSS] [--dtx] [--no-dtx]
#                                                 [--fec] [--no-fec]
#                                                 [--complexity {0,1,2,3,4,5,6,7,8,9}]
#                                                 [--framesize {2,5,10,20,40,60}]
#                                                 receiver_host
export GST_DEBUG=$GSTLOGLEVEL

case "$HOSTNAME" in
	"radio-streamer1")
		printf "Starting openob TX for radio-streamer device..\n";
		$OPENOB $CFGHOST $HOSTNAME $LINKNAME -v  tx -a jack -jn obtx-$LINKNAME -r 48000 -j 40 -e pcm $STUDIO -jp "system:capture_2";
		;;
	"jetlag-radio")
		$OPENOB $CFGHOST $HOSTNAME $LINKNAME -v  tx -a jack -jn obtx-$LINKNAME -r 48000 -j 40 -e pcm $STUDIO -jp "ardour:ob-$LINKNAME";
		;;
	"papillon-mixer")
		$OPENOB $CFGHOST $HOSTNAME $LINKNAME -v  tx -a jack -jn obtx-$LINKNAME -r 48000 -j 40 -e pcm $STUDIO -jp "ardour:ob-$LINKNAME";
		;;

esac
